# Llamar en R a la base de datos "Microalgas.csv".
datos<-read.csv2("Microalgas.csv",row.names=1)  

# Libreras requeridas
library(indicspecies)

#-------------
# Ajuste de las bases de datos biolgica (tax) y fisiqcoquimica (amb)
str(datos)    	# Estructura de la base de datos
datos$Tributario = as.factor (datos$Tributario)   	# Convertir Tributario a factor
str(datos)    	# Nueva estructura de la base de datos

# Variables ambientales
amb=log10(datos[,c(2:11)]+1)
amb

# taxones de microalgas
tax=datos[,c(12:32)]
tax



#=====================================
# Datos por sitios, transectos y meses
datos=read.csv2("datos2.csv",row.names = 1)

# multipatt - sp indicadoras en sitios como en combinaciones de sitios
str(datos)
names(datos)
indval = multipatt(datos[,3:98], datos$ESTACION,control = how(nperm=999))
summary (indval)
# especificidad (A) y fidelidad (B) de las sp indicadoras en sus grupos
summary(indval, indvalcomp=TRUE)

# Especies de todos los grupos, sin importar la significancia (alfa mayor a 0,05)
summary(indval, alpha=1)

# Incluye a especies que estn en todos los grupos
indval$sign
write.csv2(indval$sign, "indice1.csv")

# Datos por sitios, transectos y meses
datos=read.csv2("datos1.csv",row.names = 1)

library(indicspecies)

# multipatt - sp indicadoras en sitios como en combinaciones de sitios
str(datos)
names(datos)
indval = multipatt(datos[,5:100], datos$ESTACION,control = how(nperm=999))
summary (indval)
# especificidad (A) y fidelidad (B) de las sp indicadoras en sus grupos
summary(indval, indvalcomp=TRUE)

# Especies de todos los grupos, sin importar la significancia (alfa mayor a 0,05)
summary(indval, alpha=1)

# Incluye a especies que estn en todos los grupos
indval$sign
write.csv2(indval$sign, "indice2.csv")



#=====================================
# Datos por sitios y meses
datos=read.csv2("datos3.csv",row.names = 1)

library(indicspecies)

# multipatt - sp indicadoras en sitios como en combinaciones de sitios
str(datos)
names(datos)
indval = multipatt(datos[,3:98], datos$ESTACION,control = how(nperm=999))
summary (indval)

# especificidad (A) y fidelidad (B) de las sp indicadoras en sus grupos
summary(indval, indvalcomp=TRUE)

# Especies de todos los grupos, sin importar la significancia (alfa mayor a 0,05)
summary(indval, alpha=1)

# Incluye a especies que estn en todos los grupos
indval$sign
write.csv2(indval$sign, "indice3.csv")


